 ; Lump - move the entire contents of one or more layers onto a single one.
 ; Copyright 1995 by Rocket Software
 ; Anyone can use this - even if they are one.
 (DEFUN C:LUMP (/ num enam layy ss len sslist laylst dest lstlen gofor)
  (setvar "cmdecho" 0)
  (command "undo" "mark")
  (write-line "Select objects on layers to relayer:")
  (setq num 0)
  (while (setq enam (entsel))
         (setq layy (cdr (assoc 8 (entget (car enam)))))
         (if (member layy laylst)
             (princ (strcat "Layer " layy " already selected."))
             (progn
                  (setq ss (ssget "X" (list (cons 8 layy))))
                  (setq num (+ num (setq len (sslength ss))))
                  (setq sslist (append sslist (list ss)))
                  (setq laylst (append laylst (list layy)))
                  (princ (strcat layy ": " (itoa len)
                                 " entit" (if (> len 1) "ies." "y."))))))
  (if laylst
     (progn
          (setq dest (entsel "\nSelect something on the destination layer: "))
          (while (null dest) (setq dest (entsel "Try again: ")))
          (setq dest (setq dest (cdr (assoc 8 (entget (car dest))))))
          (initget 0 "Yes No")
          (setq len (if (> (setq lstlen (length laylst)) 1) "s" ""))
          (Setq gofor (getkword (strcat "\nMove selected layer" len " to "
                                         dest " <Y>? ")))
          (if (or (null gofor) (= gofor "Yes"))
              (setq gofor T)
              (progn
                   (prompt "Another attempt at rationality bites the dust.")
                   (setq gofor ())))))
  (if gofor
     (progn
          (command "change")
          (while (setq layy (car sslist))
                 (setq sslist (cdr sslist))
                 (command layy))
          (command "" "p" "layer" dest "")
          (write-line (strcat "\n" (itoa num)
                              " entit" (if (> num 1) "ies" "y")
                              " moved from " (itoa lstlen) " layer" len
                              " to " dest "."))))
 (princ))